/*
 Copyright (c) 2007, Distributed Computing Group (DCG)
                    ETH Zurich
                    Switzerland
                    dcg.ethz.ch

 All rights reserved.

 Redistribution and use in source and binary forms, with or without
 modification, are permitted provided that the following conditions
 are met:

 - Redistributions of source code must retain the above copyright
   notice, this list of conditions and the following disclaimer.

 - Redistributions in binary form must reproduce the above copyright
   notice, this list of conditions and the following disclaimer in the
   documentation and/or other materials provided with the
   distribution.

 - Neither the name 'Sinalgo' nor the names of its contributors may be
   used to endorse or promote products derived from this software
   without specific prior written permission.

 THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
 "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
 LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
 A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT
 OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
 LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
 DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
 THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
 OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
*/
package projects.defaultProject.models.messageTransmissionModels;

import sinalgo.configuration.CorruptConfigurationEntryException;
import sinalgo.nodes.Node;
import sinalgo.nodes.messages.Message;
import sinalgo.tools.statistics.Distribution;

/**
 * Dummy message transmission model whose delivery time is defined
 * through a distribution.
 * <p>
 * This class expects an entry in the configuration file that describes
 * the distribution of the delivery time.
 * <pre>
		&lt;RandomMessageTransmission distribution="Uniform" min="0.1" max="0.8"/&gt;
 * </pre>
 * If the distribution returns a value smaller or equal to 0, the transmission
 * time is set to the small positive value 1e-9.     
 */
public class RandomTime extends sinalgo.models.MessageTransmissionModel {
	Distribution dist;
	double minTime = 1e-9;
	
	/**
	 * Creates a new RandomTime transmission model instance and reads the 
	 * config for this object from the config file. 
	 * @throws CorruptConfigurationEntryException
	 */
	public RandomTime() throws CorruptConfigurationEntryException {
		dist = Distribution.getDistributionFromConfigFile("RandomMessageTransmission");
	}
	
	@Override
	public double timeToReach(Node startNode, Node endNode, Message msg) {
		double time = dist.nextSample();
		if(time <= 0) {
			time = minTime;
		}
		return time;
	}
}
