/*
 Copyright (c) 2007, Distributed Computing Group (DCG)
                    ETH Zurich
                    Switzerland
                    dcg.ethz.ch

 All rights reserved.

 Redistribution and use in source and binary forms, with or without
 modification, are permitted provided that the following conditions
 are met:

 - Redistributions of source code must retain the above copyright
   notice, this list of conditions and the following disclaimer.

 - Redistributions in binary form must reproduce the above copyright
   notice, this list of conditions and the following disclaimer in the
   documentation and/or other materials provided with the
   distribution.

 - Neither the name 'Sinalgo' nor the names of its contributors may be
   used to endorse or promote products derived from this software
   without specific prior written permission.

 THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
 "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
 LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
 A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT
 OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
 LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
 DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
 THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
 OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
*/
package projects.defaultProject.nodes.nodeImplementations;


import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import projects.defaultProject.nodes.timers.dieTimer;
import sinalgo.configuration.Configuration;
import sinalgo.configuration.CorruptConfigurationEntryException;

// La classe TimerNode est une classe dérivée de BasicNode.
// Comme son nom l'indique, elle est destinée aux algorithmes utilisant des timers
// la fonction regularly() est appelée toutes les 10 unités de temps
// Par défaut, la racine est le noeud de degré un.

public class CNode extends TimerNode {
	
	private boolean correct=true;
	private static final Lock lock = new ReentrantLock(true);
	private static boolean initialCrash;
	
	private static int k=0, x=0;
	private static int wait,f;	
	
	public boolean Correct() {
		return this.correct;
	}
	
	public boolean Faulty() {
		return !this.Correct();
	}
	
	public boolean should_die() {
		int v=this.nextInt(CNode.nbProcesses());
		return v<f;
	}
	
	public void die() {
		x++;	
		crashed=true;
		this.affiche("Process "+this.Id()+ " is dead\n");		
	}
	
	public void start(){
		  
		try {	
		    f=Configuration.getIntegerParameter("F");
		} catch (CorruptConfigurationEntryException e) {
		    f=0;
		}
		
		try {	
			initialCrash=Configuration.getBooleanParameter("ICRASH");
		} catch (CorruptConfigurationEntryException e) {
			initialCrash=false;
		}
		
		try {	
		    wait=Math.max(Configuration.getIntegerParameter("Period"),10);
		} catch (CorruptConfigurationEntryException e) {
		    wait=10;
		}
		

		 lock.lock();
		  try {
			  if(k<f && should_die()) {
					k++;			
					this.correct=false;
					if(initialCrash) {
						this.identite=this.ID+nextInt(nbProcesses())*nbProcesses();
						die();
					}
					else {
						int r=this.nextInt(CNode.nbProcesses()+1);
						if(r>0) {
						int lifetime=r * CNode.wait;
						(new dieTimer()).startRelative(lifetime, this);
						}
						else {
							this.identite=this.ID+nextInt(nbProcesses())*nbProcesses();
							die();
						}
					
					}
				}
		  } catch (Exception e) {
		      // handle the exception
		  } finally {
		      lock.unlock();
		  }	

		  super.start();
	}
	
	
	public static int F() {
		return f;
	}
	
	public static int nbFaulty() {
		return k;
	}
	
	public static int nbCorrect() {
		return CNode.nbProcesses()-k;
	}
	
	public static int nbCurrentCrash() {
		return x;
	}
	
	public static int nbCurrentUp() {
		return CNode.nbProcesses()-x;
	}
}
