/*
 * CPS Middleware Project.
 * Copyright (C) 2008-2009 
 *
 * This is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License version
 * 3.0 as published by the Free Software Foundation.
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this software; if not, see
 * http://www.gnu.org/licenses/.
 */

const MODULE_NAME_CPS3 = "cps3";
const MODULE_NAME_X86_CPS3 = "cps3_x86";
const MODULE_NAME_CPS2TER_GALSS = "cps_2ter_galss";
const MODULE_NAME_CPS2TER_PCSC = "cps_2ter_pcsc";




function asipsantePKCS11() {
  // Private Members
  function /*String*/ getOSName(platform) {
    if(platform.indexOf("Win", 0)   != -1){
      var myAgent = navigator.userAgent;
      if (myAgent.indexOf("Win64", 0) != -1 || myAgent.indexOf("x64", 0) != -1)
        return "Win64";
      return "Win32"; 
    }
    if(platform.indexOf("Linux", 0) != -1)
      return "Linux";
    if(platform.indexOf("Mac", 0)   != -1)
      return "Mac";
    return "Unknown";
  }
  
  /////////////////////////////////////////////////////////////
  function getModuleName() {
    return "Module de sécurité CPS";
  }
  
  /////////////////////////////////////////////////////////////
  // get module name that corresponds to the JSON manifest of x64 cps3 pkcs11
  function getModuleName_cps3() {
    return MODULE_NAME_CPS3;
  }
  
  /////////////////////////////////////////////////////////////
  // get module name that corresponds to the JSON manifest of x86 cps3 pkcs11
  function getModuleName_cps3_x86() {
    return MODULE_NAME_X86_CPS3;
  }
  
  ////////////////////////////////////////////////////////////////////
  // getListLibsToClean
  //////////////////////////////////////////////////////////////////////
  this.getListLibsToClean = function() {
    var myOS = navigator.platform;
    myOS = getOSName(myOS);

	var liste = "";
	if (myOS == "Win32") {
	  liste = MODULE_NAME_CPS2TER_GALSS + "," + MODULE_NAME_CPS2TER_PCSC;
	}
	if (myOS = "Win64") {
	   liste = MODULE_NAME_CPS2TER_GALSS + "," + MODULE_NAME_CPS2TER_PCSC;
	}
	if (myOS == "Mac" || myOS == "Linux") {
	   liste = MODULE_NAME_CPS2TER_GALSS + "," + MODULE_NAME_CPS3;
	}
    var reg=new RegExp("[,;]+", "g");
    var tableau = liste.split(reg);
    return tableau;
  }
  
  //////////////////////////////////////////////////////////////////////
  // verifies (by platform) if the appropriate CPS3 module is registered 
  //////////////////////////////////////////////////////////////////////
  this._isInstalledWithPlatform = async function( platform ) {
  
        var platformName = platform.os.toLowerCase();
		console.log("platformName: " + platformName);
		console.log("platform.arch: " + platform.arch);
        if (platformName === "win" || platformName === "linux") {
	        var /*Object*/ gotResult = null;
			if (platform.arch === "x86-32") {
			  this.keyName = getModuleName_cps3_x86();
			  gotResult = await browser.pkcs11.isModuleInstalled( this.keyName );
			} else {
			  this.keyName = getModuleName_cps3();
			  gotResult = await browser.pkcs11.isModuleInstalled( this.keyName );
			}
			
			if ( typeof(gotResult) === "boolean" ){
				console.log("gotResult: ", gotResult);
				this.isRegistered = gotResult;
			}
			else {
				console.log("Unsupproted object type !");
			}
		}
		else {
			var /*Object*/ gotResult = null;
		  	this.keyName = getModuleName_cps3();
			gotResult = await browser.pkcs11.isModuleInstalled( this.keyName );
			
			if ( typeof(gotResult) === "boolean" ){
				console.log("gotResult: ", gotResult);
				this.isRegistered = gotResult;
			}
			else {
				console.log("Unsupproted object type !");
			}
		}
  }
  
    //////////////////////////////////////////////////////////////////////
  // unregister (by platform) the appropriate CPS3 module 
  //////////////////////////////////////////////////////////////////////
  this._uninstallModuleWithPlatform = async function( platform ) {
		var /*Object*/ gotResult = null;
        var platformName = platform.os.toLowerCase();
        if (platformName === "win" || platformName === "linux") {
			if (platform.arch === "x86-32") {
			  this.keyName = getModuleName_cps3_x86();
			} else {
			  this.keyName = getModuleName_cps3();
			}
			gotResult = browser.pkcs11.uninstallModule( this.keyName );
			gotResult.then(() => console.log("unregisterModule OK")).catch(() => console.error("uninstallModule failed"));
		}
		else {
		  	this.keyName = getModuleName_cps3();
			gotResult = browser.pkcs11.uninstallModule( this.keyName );
			gotResult.then(() => console.log("unregisterModule OK")).catch(() => console.error("uninstallModule failed"));
		}
  }
  
  //////////////////////////////////////////////////////////////////////
  // verifies if the CPS3 module name is registered 
  //////////////////////////////////////////////////////////////////////
  this.isModuleInstalled = async function() {
  
    this.isRegistered = -1;
	// the module key name to use for registration
	this.keyName = "";
	
	var gettingInfo = await browser.runtime.getPlatformInfo()
    //gettingInfo.then( this._isInstalledWithPlatform ).catch(console.log("module could not be detected"));
	if ( gettingInfo != null) {
	  await this._isInstalledWithPlatform ( gettingInfo );
	}
  }
  
  //////////////////////////////////////////////////////////////////////
  // register the CPS3 module name 
  //////////////////////////////////////////////////////////////////////
  this.registerModule = async function() {
  
	// check pkcs11 API is available ...
	if (typeof browser.pkcs11 !== 'undefined') {
	  await this.isModuleInstalled();
	  if (this.isRegistered == false) {
	    await browser.pkcs11.installModule(this.keyName, 0).then(() => console.log("installModule result OK")).catch(err => console.error("installModule failed", err));
	  }
	}
	else {
	  console.log("pkcs11 API is not available (register). ");
	}
  }
  
  //////////////////////////////////////////////////////////////////////
  // unregister the CPS3 module name 
  //////////////////////////////////////////////////////////////////////
  this.unregisterModule = async function() {
    
	// check pkcs11 API is available ...
	if (typeof browser.pkcs11 !== 'undefined') {
	  var gettingInfo = browser.runtime.getPlatformInfo();
	  gettingInfo.then(this._uninstallModuleWithPlatform);
	  
	}
	else {
	  console.log("pkcs11 API is not available (unregisterModule).");
	}
  }
  
  this.unregisterModuleNotWait = function() {
    
	// check pkcs11 API is available ...
	if (typeof browser.pkcs11 !== 'undefined') {
	  console.log("uninstall cps3 not wait !!");
	  var gotResult = browser.pkcs11.uninstallModule(getModuleName_cps3());
	  // console.log("gotResult: ", gotResult);
	  gotResult.then(() => {console.log("OK");}).catch(err => console.error(err));
	}
	else {
	  console.log("pkcs11 API is not available yet (unregisterModuleNotWait).");
	}
  }
  
  //////////////////////////////////////////////////////////////////////
  // unregister by module name 
  //////////////////////////////////////////////////////////////////////
  this.unregisterOldModules = async function (force) {

    var libsArray = this.getListLibsToClean();
	console.log("libsArray: ", libsArray);
	
	for (var i=0; i<libsArray.length; i++){
	    if (typeof browser.pkcs11 !== 'undefined') {
	      console.log( "Uninstalling: ", libsArray[i] );
	      await browser.pkcs11.uninstallModule(libsArray[i]).then(() => console.log("uninstalled OK")).catch(err => console.error("catch ", err));
		}
	}	
  }
}
