/*
 * cps Middleware Project.
 * Copyright (C) 2008-2017 
 *
 * This is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License version
 * 3.0 as published by the Free Software Foundation.
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this software; if not, see
 * http://www.gnu.org/licenses/.
 */

function call_wait() {
  return "call_wait: " + 3400;
}

function clbk_onDisabled(extInfo) {
  var cpsPKCS11 = new asipsantePKCS11();
  cpsPKCS11.unregisterModuleNotWait();
}

var asipsante = {

  cpsPKCS11: null,

  onLoad: async function(evt) {
    console.log("arch: " + browser.runtime.PlatformArch);
	console.log("OS  : " + browser.runtime.PlatformOs);
	
	this.cpsPKCS11 = new asipsantePKCS11();
	
	// supprimer les anciennes librairies pkcs11 de l'asip.
    await this.cpsPKCS11.unregisterOldModules(0);
	
	console.log("registerModule called !");
	await this.cpsPKCS11.registerModule();
	
	browser.management.onDisabled.addListener(clbk_onDisabled);
    browser.management.onUninstalled.addListener(clbk_onDisabled);
	
  },
  
  removeIDs: /*callback*/ function(addon) {
    /*
	var cpsPKCS11 = new asipsantePKCS11();
    var arrayIDs = cpsPKCS11.getListIDsToClean();
	
	console.log("In callback, add-on version: ", addon.version);
	theAddonVersion = addon.version;
	console.log("In callback, addon id     : ", addon);
	theAddonID = addon.id;
	
	// Test si module version precedente est present : si OUI, desinstalle
    for (var i=0; i<arrayIDs.length; i++) {
        // Suppresion des anciens modules...
		var getting = browser.management.get(arrayIDs[i]);
		
		// Si promesse resolue, on appelle gotInfoAndRemove
		getting.then(gotInfoAndRemove);
	}*/
  },
  
  onDisabled: function(extInfo) {
	this.cpsPKCS11.unregisterModule();
  },

}



/* Recuperer l'extension courante */
/* pour supprimer ensuite les anciennes extensions possiblement prsentes */
var /*Promise*/ gettingSelf = browser.management.getSelf();
gettingSelf.then(asipsante.removeIDs);

// Remove CPS3 security module when FF is stopped
// for the case where our addon would be disabled.
// it won't be loaded at next Firefox start

window.addEventListener('load'  , function(e) { asipsante.onLoad(e); }, false);
window.addEventListener('unload', function(e) { var cpsPKCS11 = new asipsantePKCS11(); cpsPKCS11.unregisterModule();}, false);

