/*
Default settings. Initialize storage to these values.
*/

var authCredentials = {
  firstRun: false,
  version: "6.0.16"
};

/*
Generic error logger.
*/
function onError(e) {
  console.error(e);
}

/*
On startup, check whether we have stored settings.
If we don't, then store the default settings.
*/
function checkStoredSettings(storedSettings) {
  if (!storedSettings.version) {
    console.log("firstRun: true");
    browser.storage.local.set(authCredentials);
  }
  else {
    console.log("firstRun: false");
  }
}

const /*Promise*/ gettingStoredSettings = browser.storage.local.get();
gettingStoredSettings.then(checkStoredSettings, onError);
